/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.fluid;

import cofh.lib.fluid.FluidStorageCoFH;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidStorageRestrictable
extends FluidStorageCoFH {
    protected IntSupplier maxFill = this::getCapacity;
    protected IntSupplier maxDrain = this::getCapacity;

    public FluidStorageRestrictable(int capacity) {
        this(capacity, e -> true);
    }

    public FluidStorageRestrictable(int capacity, Predicate<FluidStack> validator) {
        super(capacity, validator);
    }

    public FluidStorageRestrictable setTransferLimits(IntSupplier maxFill, IntSupplier maxDrain) {
        this.maxFill = maxFill;
        this.maxDrain = maxDrain;
        return this;
    }

    @Override
    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.getAmount() > this.maxFill.getAsInt()) {
            return super.fill(new FluidStack(resource, this.maxFill.getAsInt()), action);
        }
        return super.fill(resource, action);
    }

    @Override
    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return super.drain(Math.min(maxDrain, this.maxDrain.getAsInt()), action);
    }
}

